/** @file   BadAssAi.cpp
 * @brief   Implementation of BadAssAi class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/07/13 16:28:01 $
 * @author  Tomi Lamminsaari
 */

#include "BadAssAi.h"
#include "warglobals.h"
#include "utils.h"
#include "www_assert.h"
using namespace eng2d;

namespace WeWantWar {

///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
BadAssAi::BadAssAi( GameObject* aObject ) :
  AIController( aObject )
{
  AIController::m_visualRange = 500;
  AIController::m_attackRange = 300;
  this->setFlags( AIController::WAIT_TARGET );
}



/** Destructor.
 */
BadAssAi::~BadAssAi()
{
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================

/** Updates this controller.
 */
void BadAssAi::updateAI( bool aSeeTarget, float aDistance )
{
  bool withinRange = this->withinAttackRange();
  bool weaponReady = !m_pObject->reloading();
  bool facingTarget = Utils::isFacingObject( m_pObject, m_pTarget, 20 );
  Vec2D ourPos = m_pObject->position();
  Vec2D targetPos = m_pTarget->position();
  int ourAngle = m_pObject->angle();
  
  if ( iAlerted == false ) {
    if ( aSeeTarget == true ) {
      iAlerted = true;
    } else {
      // We haven't seen player yet, so we stay put
      this->reset();
      this->setCounter( 5 + rand() % 5 );
      return;
    }
  }
  this->setRandomMovement( 10 + rand() % 10 );
  
  if ( aSeeTarget == true ) {
    if ( withinRange == true ) {
      if ( facingTarget == true ) {
        if ( weaponReady == true ) {
          // We're ready to shoot.
          this->reset();
          this->shoot() = 1;
          this->setCounter( 10 );
          if ( aDistance > 120 ) {
            this->forward() = rand() % 2;
          }
          int r = rand() % 4;
          if ( r == 1 ) {
            this->left() = 1;
          } else if ( r == 2 ) {
            this->right() = 1;
          }
          return;
        } else {
          // We're pointing to the target but our gun is not ready.
          this->setRandomMovement( 12 + (rand()%15) );
          this->avoidWalls();
          return;
        }
        
      } else {
        // We're not facing the target. Keep turning towards him.
        this->reset();
        this->forward() = 1;
        int d = Utils::findTurningDir( ourPos, targetPos, ourAngle );
        this->turn() = 2*d;
        if ( aDistance < 80 ) {
          this->forward() = 0;
          this->turn() = 4*d;  // turn more quickly
        }
        this->avoidWalls();
        return;
      }
      
    } else {
      // We're not within the range. Get closer. Use A* algorithm to find path
      // to the player.
      AStarAlgorithm algo( *this );
      algo.SetMaxRouteNodes( 64 );
      bool pathFound = algo.FindPath( ourPos, targetPos );
      const MPathFinderAlgo::NodeArray& nodes = algo.GetPathNodes();
      if ( pathFound == true && nodes.size() > 2 ) {
        // We found the route.
        Vec2D nodePos( nodes.at(1) );
        int d = Utils::findTurningDir( ourPos, nodePos, ourAngle );
        this->reset();
        this->forward() = 1;
        this->turn() = 4*d;
        this->setCounter( 2 + rand() % 3 );
        return;
      } else {
        // No path from our current position to the player. Move randomly.
        return;
      }
    }
  } else {
    // We don't see the target.
    AStarAlgorithm algo( *this );
    algo.SetMaxRouteNodes( 64 );
    bool pathFound = algo.FindPath( ourPos, targetPos );
    const MPathFinderAlgo::NodeArray& nodes = algo.GetPathNodes();
    if ( pathFound == true && nodes.size() > 2 ) {
      Vec2D nodePos( nodes.at(1) );
      int d = Utils::findTurningDir( ourPos, nodePos, ourAngle );
      this->reset();
      this->forward() = 1;
      this->turn() = 4*d;
      this->setCounter( 2 + rand() % 3 );
      return;
    } else {
      // No path to the target. Move randomly.
      return;
    }
  }
}

void BadAssAi::setAlerted(bool aAlerted)
{
  iAlerted = aAlerted;
  AIController::m_flags &= ~AIController::WAIT_TARGET;
}

};  // end of namespace
